*** Tables for Ansell & Samuels (2014) Chapter Six

*** Please use "Ansell Samuels Chapters Five and Six.dta"

*** Code includes esttab commands to produce tables, information available at http://repec.org/bocode/e/estout/esttab.html


*** Commands for Trichotomy tables (NB uses Clarify - see http://gking.harvard.edu/clarify) (Table 6.1) ***
 
estsimp oprobit trichotomy lfullaut lnondem lbmginiint lbmgdppint LagRuralInequality lfalbmgini lfalbmgdpp lfalRI lndlbmgini ///
 lndlbmgdpp lndlRI,  
setx lfullaut 1 lnondem 1 lbmgdppint mean LagRuralInequality mean lfalbmgdpp mean lfalRI mean lndlbmgdp mean lndlRI mean'
 simqi, fd(pr) changex(lbmginiint .3 .55 lfalbmgini .3 .55 lndlbmgini .3 .55)
 setx lfullaut 0 lnondem 1 lbmgdppint mean LagRuralInequality mean lfalbmgdpp 0 lfalRI 0 lndlbmgdp mean lndlRI mean
  simqi, fd(pr) changex(lbmginiint .3 .55 lfalbmgini 0 0  lndlbmgini .3 .55)
  setx lfullaut 0 lnondem 0 lbmgdppint mean LagRuralInequality mean lfalbmgdpp 0 lfalRI 0 lndlbmgdp 0 lndlRI 0
  simqi, fd(pr) changex(lbmginiint .3 .55 lfalbmgini 0 0 lndlbmgini 0 0)
  
  setx lfullaut 1 lnondem 1 lbmgdppint mean lbmginiint mean LagRuralInequality mean lfalbmgdpp mean lfalbmgini mean lndlbmgdp mean lndlbmgini mean
 simqi, fd(pr) changex(LagRuralInequality 0 .95 lndlRI 0 .95 lfalRI 0 .95)
 setx lfullaut 0 lnondem 1 lbmgdppint mean lbmginiint mean LagRuralInequality mean lfalbmgdpp 0 lfalbmgini 0 lndlbmgdp mean lndlbmgini mean
simqi, fd(pr) changex(LagRuralInequality 0 .95 lndlRI 0 .95 lfalRI 0 0) level(95)
setx lfullaut 0 lnondem 0 lbmgdppint mean lbmginiint mean LagRuralInequality mean lfalbmgdpp 0 lfalbmgini 0 lndlbmgdp 0 lndlbmgini 0
simqi, fd(pr) changex(LagRuralInequality 0 .95 lndlRI 0 0 lfalRI 0 0) level(95)

*** Polity Thresholds (Figures 6.1 through 6.4) ***

*BM*
probit pol10 lpol10 lbmginiint lbmgdppint lpol10lbmgini lpol10lbmgdpp ///
lpol10LagRural lpol10LagVH LagVHknow   LagRuralInequality    year yearsq , r
eststo m1
probit pol9 lpol9 lbmginiint lbmgdppint lpol9lbmgini lpol9lbmgdpp ///
lpol9LagRural lpol9LagVH LagVHknow   LagRuralInequality    year yearsq , r
eststo m2
probit pol8 lpol8 lbmginiint lbmgdppint lpol8lbmgini lpol8lbmgdpp ///
lpol8LagRural lpol8LagVH LagVHknow   LagRuralInequality    year yearsq , r
eststo m3
probit pol7 lpol7 lbmginiint lbmgdppint lpol7lbmgini lpol7lbmgdpp ///
lpol7LagRural lpol7LagVH LagVHknow   LagRuralInequality    year yearsq , r
eststo m4
probit pol6 lpol6 lbmginiint lbmgdppint lpol6lbmgini lpol6lbmgdpp ///
lpol6LagRural lpol6LagVH LagVHknow   LagRuralInequality    year yearsq , r
eststo m5
probit pol5 lpol5 lbmginiint lbmgdppint lpol5lbmgini lpol5lbmgdpp ///
lpol5LagRural lpol5LagVH LagVHknow   LagRuralInequality    year yearsq , r
eststo m6
probit pol4 lpol4 lbmginiint lbmgdppint lpol4lbmgini lpol4lbmgdpp ///
lpol4LagRural lpol4LagVH LagVHknow   LagRuralInequality    year yearsq , r
eststo m7
probit pol3 lpol3 lbmginiint lbmgdppint lpol3lbmgini lpol3lbmgdpp ///
lpol3LagRural lpol3LagVH LagVHknow   LagRuralInequality    year yearsq , r
eststo m8
probit pol2 lpol2 lbmginiint lbmgdppint lpol2lbmgini lpol2lbmgdpp ///
lpol2LagRural lpol2LagVH LagVHknow   LagRuralInequality    year yearsq , r
eststo m9
probit pol1 lpol1 lbmginiint lbmgdppint lpol1lbmgini lpol1lbmgdpp ///
lpol1LagRural lpol1LagVH LagVHknow   LagRuralInequality    year yearsq , r
eststo m10
probit polm0 lpolm0 lbmginiint lbmgdppint lpolm0lbmgini lpolm0lbmgdpp ///
lpolm0LagRural lpolm0LagVH LagVHknow   LagRuralInequality    year yearsq , r
eststo m11
probit polm1 lpolm1 lbmginiint lbmgdppint lpolm1lbmgini lpolm1lbmgdpp ///
lpolm1LagRural lpolm1LagVH LagVHknow   LagRuralInequality    year yearsq , r
eststo m12
probit polm2 lpolm2 lbmginiint lbmgdppint lpolm2lbmgini lpolm2lbmgdpp ///
lpolm2LagRural lpolm2LagVH LagVHknow   LagRuralInequality    year yearsq , r
eststo m13
probit polm3 lpolm3 lbmginiint lbmgdppint lpolm3lbmgini lpolm3lbmgdpp ///
lpolm3LagRural lpolm3LagVH LagVHknow   LagRuralInequality    year yearsq , r
eststo m14
probit polm4 lpolm4 lbmginiint lbmgdppint lpolm4lbmgini lpolm4lbmgdpp ///
lpolm4LagRural lpolm4LagVH LagVHknow   LagRuralInequality    year yearsq , r
eststo m15
probit polm5 lpolm5 lbmginiint lbmgdppint lpolm5lbmgini lpolm5lbmgdpp ///
lpolm5LagRural lpolm5LagVH LagVHknow   LagRuralInequality    year yearsq , r
eststo m16
probit polm6 lpolm6 lbmginiint lbmgdppint lpolm6lbmgini lpolm6lbmgdpp ///
lpolm6LagRural lpolm6LagVH LagVHknow   LagRuralInequality    year yearsq , r
eststo m17
probit polm7 lpolm7 lbmginiint lbmgdppint lpolm7lbmgini lpolm7lbmgdpp ///
lpolm7LagRural lpolm7LagVH LagVHknow   LagRuralInequality    year yearsq , r
eststo m18
probit polm8 lpolm8 lbmginiint lbmgdppint lpolm8lbmgini lpolm8lbmgdpp ///
lpolm8LagRural lpolm8LagVH LagVHknow   LagRuralInequality    year yearsq , r
eststo m19
probit polm9 lpolm9 lbmginiint lbmgdppint lpolm9lbmgini lpolm9lbmgdpp ///
lpolm9LagRural lpolm9LagVH LagVHknow   LagRuralInequality    year yearsq , r
eststo m20

esttab m20 m19 m18 m17 m16 m15 m14 m13 m12 m11  using "bmthresholds.tex", label star (* 0.10 ** 0.05 *** 0.01) b(%12.3f) se(%12.3f) ///
 booktabs replace frag  compress nomtitles nodepvars 

esttab m10 m9 m8 m7 m6 m5 m4 m3 m2 m1 using "bmthresholds2.tex", label star (* 0.10 ** 0.05 *** 0.01) b(%12.3f) se(%12.3f) ///
 booktabs replace frag  compress nomtitles nodepvars 

** Bar Polity Thresholds

  probit polm9 lpolm9 Lagsbginiext LagMadgdpcapINT lpolm9lginiBab lpolm9lgdppMad ///
lpolm9LagRural lpolm9LagVH LagVHknow   LagRuralInequality    year  , r 
eststo m1

  probit polm8 lpolm8 Lagsbginiext LagMadgdpcapINT lpolm8lginiBab lpolm8lgdppMad ///
lpolm8LagRural lpolm8LagVH LagVHknow   LagRuralInequality    year  , r 
eststo m2

  probit polm7 lpolm7 Lagsbginiext LagMadgdpcapINT lpolm7lginiBab lpolm7lgdppMad ///
lpolm7LagRural lpolm7LagVH LagVHknow   LagRuralInequality    year  , r 
eststo m3

  probit polm6 lpolm6 Lagsbginiext LagMadgdpcapINT lpolm6lginiBab lpolm6lgdppMad ///
lpolm6LagRural lpolm6LagVH LagVHknow   LagRuralInequality    year  , r 
eststo m4

 probit polm5 lpolm5 Lagsbginiext LagMadgdpcapINT lpolm5lginiBab lpolm5lgdppMad ///
lpolm5LagRural lpolm5LagVH LagVHknow   LagRuralInequality    year  , r 
eststo m5

  probit polm4 lpolm4 Lagsbginiext LagMadgdpcapINT lpolm4lginiBab lpolm4lgdppMad ///
lpolm4LagRural lpolm4LagVH LagVHknow   LagRuralInequality    year  , r 
eststo m6

probit polm3 lpolm3 Lagsbginiext LagMadgdpcapINT lpolm3lginiBab lpolm3lgdppMad ///
lpolm3LagRural lpolm3LagVH LagVHknow   LagRuralInequality    year  , r 
eststo m7

  probit polm2 lpolm2 Lagsbginiext LagMadgdpcapINT lpolm2lginiBab lpolm2lgdppMad ///
lpolm2LagRural lpolm2LagVH LagVHknow   LagRuralInequality    year  , r 
eststo m8

  probit polm1 lpolm1 Lagsbginiext LagMadgdpcapINT lpolm1lginiBab lpolm1lgdppMad ///
lpolm1LagRural lpolm1LagVH LagVHknow   LagRuralInequality    year  , r 
eststo m9

  probit polm0 lpolm0 Lagsbginiext LagMadgdpcapINT lpolm0lginiBab lpolm0lgdppMad ///
lpolm0LagRural lpolm0LagVH LagVHknow   LagRuralInequality    year  , r 
eststo m10

  probit pol1 lpol1 Lagsbginiext LagMadgdpcapINT lpol1lginiBab lpol1lgdppMad ///
lpol1LagRural lpol1LagVH LagVHknow   LagRuralInequality    year  , r 
eststo m11

  probit pol2 lpol2 Lagsbginiext LagMadgdpcapINT lpol2lginiBab lpol2lgdppMad ///
lpol2LagRural lpol2LagVH LagVHknow   LagRuralInequality    year  , r 
eststo m12

  probit pol3 lpol3 Lagsbginiext LagMadgdpcapINT lpol3lginiBab lpol3lgdppMad ///
lpol3LagRural lpol3LagVH LagVHknow   LagRuralInequality    year  , r 
eststo m13

  probit pol4 lpol4 Lagsbginiext LagMadgdpcapINT lpol4lginiBab lpol4lgdppMad ///
lpol4LagRural lpol4LagVH LagVHknow   LagRuralInequality    year  , r 
eststo m14

  probit pol5 lpol5 Lagsbginiext LagMadgdpcapINT lpol5lginiBab lpol5lgdppMad ///
lpol5LagRural lpol5LagVH LagVHknow   LagRuralInequality    year  , r 
eststo m15

  probit pol6 lpol6 Lagsbginiext LagMadgdpcapINT lpol6lginiBab lpol6lgdppMad ///
lpol6LagRural lpol6LagVH LagVHknow   LagRuralInequality    year  , r 
eststo m16

  probit pol7 lpol7 Lagsbginiext LagMadgdpcapINT lpol7lginiBab lpol7lgdppMad ///
lpol7LagRural lpol7LagVH LagVHknow   LagRuralInequality    year  , r 
eststo m17

  probit pol8 lpol8 Lagsbginiext LagMadgdpcapINT lpol8lginiBab lpol8lgdppMad ///
lpol8LagRural lpol8LagVH LagVHknow   LagRuralInequality    year  , r 
eststo m18

  probit pol9 lpol9 Lagsbginiext LagMadgdpcapINT lpol9lginiBab lpol9lgdppMad ///
lpol9LagRural lpol9LagVH LagVHknow   LagRuralInequality    year  , r 
eststo m19

  probit pol10 lpol10 Lagsbginiext LagMadgdpcapINT lpol10lginiBab lpol10lgdppMad ///
lpol10LagRural lpol10LagVH LagVHknow   LagRuralInequality    year  , r 
eststo m20

esttab m1 m2 m3 m4 m5 m6 m7 m8 m9 m10  using "barthresholds.tex", label star (* 0.10 ** 0.05 *** 0.01) b(%12.3f) se(%12.3f) ///
 booktabs replace frag  compress nomtitles nodepvars 

esttab m11 m12 m13 m14 m15 m16 m17 m18 m19 m20 using "barthresholds2.tex", label star (* 0.10 ** 0.05 *** 0.01) b(%12.3f) se(%12.3f) ///
 booktabs replace frag  compress nomtitles nodepvars 


*** Polity Components (Table 6.2) ***

 
 reg goertz_xconst l.goertz_xconst lbmginiint lbmgdppint LagRuralInequality LagVHknow year yearsq  if sovereign ==1, cluster(bmcode)
eststo m1
reg goertz_exrec l.goertz_exrec lbmginiint lbmgdppint LagRuralInequality LagVHknow year yearsq   if sovereign ==1,cluster(bmcode)
eststo m2
reg goertz_parcomp l.goertz_parcomp lbmginiint lbmgdppint LagRuralInequality LagVHknow year yearsq  if sovereign ==1, cluster(bmcode)
eststo m3
oprobit goertz_xconst  lbmginiint lbmgdppint LagRuralInequality LagVHknow year yearsq  if sovereign ==1, r
eststo m4
oprobit goertz_exrec lbmginiint lbmgdppint LagRuralInequality LagVHknow year yearsq   if sovereign ==1, r
eststo m5
oprobit goertz_parcomp lbmginiint lbmgdppint LagRuralInequality LagVHknow year yearsq  if sovereign ==1, r
eststo m6

esttab m1 m2 m3 m4 m5 m6 using "goertz_pol_bm.tex", label star (* 0.10 ** 0.05 *** 0.01) b(%12.3f) se(%12.3f) ///
 booktabs replace frag drop (year yearsq)  compress nomtitles nodepvars 
 
 reg goertz_xconst l.goertz_xconst  Lagsbginiext LagMadgdpcapINT  LagRuralInequality  LagVHknowledgeINT oilexp islam50  year regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  regc11,r
eststo m1
reg goertz_exrec l.goertz_exrec  Lagsbginiext LagMadgdpcapINT  LagRuralInequality  LagVHknowledgeINT oilexp islam50  year regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  regc11,r 
  eststo m2
 reg goertz_parcomp l.goertz_parcomp  Lagsbginiext LagMadgdpcapINT  LagRuralInequality  LagVHknowledgeINT oilexp islam50  year regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  regc11,r
 eststo m3
oprobit goertz_xconst  Lagsbginiext LagMadgdpcapINT  LagRuralInequality  LagVHknowledgeINT oilexp islam50  year regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  regc11,r
eststo m4
oprobit  goertz_exrec   Lagsbginiext LagMadgdpcapINT  LagRuralInequality  LagVHknowledgeINT oilexp islam50  year regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  regc11,r 
 eststo m5
 oprobit goertz_parcomp  Lagsbginiext LagMadgdpcapINT  LagRuralInequality  LagVHknowledgeINT oilexp islam50  year regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  regc11,r
 eststo m6

esttab m1 m2 m3 m4 m5 m6 using "goertz_pol_bar.tex", label star (* 0.10 ** 0.05 *** 0.01) b(%12.3f) se(%12.3f) ///
 booktabs replace frag drop (year regc***)  compress nomtitles nodepvars
 
  
 
 ** Inequality in High and Low Income States (Table 6.3) **

probit democracy lagdemocracy lbmginiint lbmgdppint ldemlbmginiint ldemlbmgdp LagVHknow LagDemXLagVHk  LagRuralInequality LagDemXLagRuralInequality ///
  year yearsq if lbmgdpp_pct<=50, cluster(bmcode)
eststo m1
probit democracy lagdemocracy lbmginiint lbmgdppint ldemlbmginiint ldemlbmgdp LagVHknow LagDemXLagVHk  LagRuralInequality LagDemXLagRuralInequality ///
  year yearsq if lbmgdpp_pct>50, cluster(bmcode)
eststo m2
probit democracy lagdemocracy Lagsbginiext LagDemXLagsbginiext LagMadgdpcapINT LagDemXLagMadgdpcapINT LagRuralInequality  LagDemXLagRuralInequality ///
 LagVHknowledgeINT LagDemXLagVHknowlInt   islam50 LagDemXislam50 lcwarten LagDemXlcwarten   year regc2 regc3 regc4 regc5 regc6 regc7 ///
 regc8 regc9  regc11 if LagMadGdp_pct<=50, r
eststo m3
probit democracy lagdemocracy Lagsbginiext LagDemXLagsbginiext LagMadgdpcapINT LagDemXLagMadgdpcapINT LagRuralInequality  LagDemXLagRuralInequality ///
 LagVHknowledgeINT LagDemXLagVHknowlInt   islam50 LagDemXislam50 lcwarten LagDemXlcwarten   year regc2 regc3 regc4 regc5 regc6 regc7 ///
 regc8 regc9  regc11 if LagMadGdp_pct>50, r
eststo m4


esttab m1 m2 m3 m4 using "ginihighlow.tex", label star (* 0.10 ** 0.05 *** 0.01) b(%12.3f) se(%12.3f) ///
 booktabs replace frag drop (year yearsq regc** o.regc**) rename(LagMadgdpcapINT lbmgdppint LagDemXLagMadgdpcapINT ldemlbmgdppint)  compress nomtitles nodepvars eqlabels(, none)


 
 
 *** Capital Shares (Table 6.4)


probit democracy lagdemocracy lkshare_2 LagDemXlkshare_2 LagMadgdpcapINT LagDemXLagMadgdpcapINT ///
   year regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  regc11 , cluster(ccode)
  eststo m1

probit democracy lagdemocracy lkshare_2 LagDemXlkshare_2 LagMadgdpcapINT LagDemXLagMadgdpcapINT ///
  LagRuralInequality  LagDemXLagRuralInequality lcwarten LagDemXlcwarten    islam50 LagDemXislam50 l.pwt_logpop c.lagdemocracy#c.l.pwt_logpop ///
  l.pwt_openk c.lagdemocracy#c.l.pwt_openk   i.regcode , cluster(ccode)
  eststo m2
  
  probit democracy lagdemocracy lkshare_2 LagDemXlkshare_2 LagMadgdpcapINT LagDemXLagMadgdpcapINT Lagsbginiext LagDemXLagsbginiext ///
   year regc2 regc3 regc4 regc5 regc6 regc7 regc8 regc9  regc11 , cluster(ccode)
  eststo m3

probit democracy lagdemocracy lkshare_2 LagDemXlkshare_2 LagMadgdpcapINT LagDemXLagMadgdpcapINT Lagsbginiext LagDemXLagsbginiext ///
 LagRuralInequality  LagDemXLagRuralInequality lcwarten LagDemXlcwarten    islam50 LagDemXislam50 l.pwt_logpop c.lagdemocracy#c.l.pwt_logpop ///
  l.pwt_openk c.lagdemocracy#c.l.pwt_openk   i.regcode , cluster(ccode)
  eststo m4


esttab m1 m2 m3 m4  using "capshares_new.tex", label star (* 0.10 ** 0.05 *** 0.01) b(%12.3f) se(%12.3f) eqlabels(,none) ///
 booktabs replace  frag  drop(year regc** *.regcode **.regcode o.regc**)  compress nomtitles nodepvars coeflabels (lkshare_2 "Capital Share" LagDemXlkshare_2 "Lag Dem X Cap Share" L.pwt_logpop "Log Population" ///
 c.lagdemocracy#cL.pwt_logpop "Lag Dem X Log Pop" L.pwt_openk "Openness" c.lagdemocracy#cL.pwt_openk "Lag Dem X Openness" lcapshare "Capital Share (Houle)" LagDemXcapshare "Lag Dem X Cap Share") ///
 order(lagdemocracy lkshare_2 LagDemXlkshare_2 LagMadgdpcapINT LagDemXLagMadgdpcapINT Lagsbginiext LagDemXLagsbginiext )



 
